/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1999 Parametric Technology Corporation.
	All rights reserved.
*/

#ifndef __PROD_UTILS_H__
#define __PROD_UTILS_H__
using namespace ProDESKTOPLib;
using namespace ADPREFERENCELib;

// Declarations of Globlal Functions

HRESULT  GetProDESKTOPApplication(IApplication **ProDESKTOPApp);

HRESULT  RunProDESKTOP(IApplication **app);

HRESULT CloseProDESKTOP();

HRESULT GetActiveWorkplaneSketch(	 IGraphicDocument **activeGraphicDoc,
									 IWorkplane **activeWorkplane,
									 ISketch **activeSketch);

bool IsFileSaved(IGraphicDocument *activeGraphicDoc);

HRESULT CreateLine(double startX, double startY, double endX, double endY, ILine **dCurve1);

#define CAST(cls, obj) \
	CastInterface<cls>(obj,IID_##cls) \

template <class T> 
T *CastInterface(IDispatch *disp,GUID iid)
{
	void *pUnk;
	HRESULT status = disp->QueryInterface(iid,(void **)&pUnk);
	VERIFY(!status);
	return (T *)pUnk;

}

#define GetCLASS(cls) \
	GetFormalClass<I##cls##Class>(IID_I##cls##Class, #cls) \

template <class T>
T *GetFormalClass(GUID iid, CString clsName)
{
	IDispatch *disp = NULL;
	HRESULT status = pdApp->GetClass(clsName.AllocSysString(), &disp);

	T *thisCls = NULL;
	status = disp->QueryInterface(iid, (void **)&thisCls);
	if(status || !thisCls) {
		AfxMessageBox("QueryInterface Failed");
		return NULL;
	}
	return thisCls;
}

#endif	// __PROD_UTILS_H__




